<?php
$LogFile = 'downloads.log';
$TelegramToken = '7607895685:AAFzF4-FRzFEk0rKAMzeqiMwVCrpRBjlnYU';
$TelegramChatID = '884084041';

// Read log and filter today's entries
if (!file_exists($LogFile)) exit("Log file not found.");

$lines = file($LogFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES);
$today = date('Y-m-d');

$todayEntries = array_filter($lines, function($line) use ($today) {
    return strpos($line, $today) === 0;
});

if (empty($todayEntries)) {
    $message = "📊 Daily Summary: No downloads today ($today)";
} else {
    $message = "📊 Daily Download Summary for $today:\n\n";
    foreach ($todayEntries as $entry) {
        $message .= "• " . $entry . "\n";
    }
}

// Send to Telegram
$telegramApiUrl = "https://api.telegram.org/bot$TelegramToken/sendMessage";
$postData = [
    'chat_id' => $TelegramChatID,
    'text' => $message,
    'parse_mode' => 'HTML'
];

$ch = curl_init($telegramApiUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($postData));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_exec($ch);
curl_close($ch);

// Optional: clear log after sending
// file_put_contents($LogFile, '');
?>
